

PROCEDURE PSIMPLEX(
       M,N          :INTEGER;
       EPS          :REAL;
   VAR A            :ARRM2N;
   VAR B,X          :ARRM2;
   VAR C            :ARRN;
   VAR W            :ARRM;
   VAR F            :REAL;
   VAR NOFEAS,NOSOL :BOOLEAN);

   VAR I,J,K,L,P,Q  :INTEGER;
       D,R,S        :REAL;
       U            :ARRM2M2;
       Y            :ARRM2;
       EX,PHASE,STOP:BOOLEAN;
BEGIN
   NOFEAS:=FALSE;  NOSOL:=FALSE;
   P:=M+2;  Q:=M+2;
   PHASE:=TRUE;
   K:=M+1;
   FOR J:=1 TO N DO BEGIN
      A[K,J]:=C[J];
      S:=0.0;
      FOR I:=1 TO M DO S:=S-A[I,J];
      A[P,J]:=S
   END;  { FOR J }
   S:=0.0;
   FOR I:=1 TO M DO BEGIN
      W[I]:=N+I;
      R:=B[I];  X[I]:=R;
      S:=S-R
   END;  { FOR I }
   X[K]:=0.0;  X[P]:=S;
   FOR I:=1 TO P DO BEGIN
      FOR J:=1 TO P DO U[I,J]:=0.0;
      U[I,I]:=1.0
   END;
   STOP:=FALSE;
   REPEAT  { UNTIL STOP }                                 { PHASE 1 }
      IF (X[P] >= -EPS) AND PHASE THEN BEGIN
         PHASE:=FALSE;  Q:=M+1
      END;
      D:=0.0;                                             { PHASE 2 }
      FOR J:=1 TO N DO BEGIN
         S:=0.0;
         FOR I:=1 TO P DO S:=S+U[Q,I]*A[I,J];
         IF D > S THEN BEGIN D:=S;  K:=J END
      END;  { FOR J }
      IF D > -EPS THEN BEGIN
         STOP:=TRUE;
         IF PHASE THEN NOFEAS:=TRUE
         ELSE F:=-X[Q]
      END
      ELSE BEGIN
         FOR I:=1 TO Q DO BEGIN
            S:=0.0;
            FOR J:=1 TO P DO S:=S+U[I,J]*A[J,K];
            Y[I]:=S
         END;  { FOR I }
         EX:=TRUE;
         FOR I:=1 TO M DO
            IF Y[I] >= EPS THEN BEGIN
               S:=X[I]/Y[I];
               IF EX OR (S < D) THEN BEGIN D:=S;  L:=I END;
               EX:=FALSE
            END;  { IF Y[I] >= EPS }
         IF EX THEN BEGIN NOSOL :=TRUE;  STOP:=TRUE END
         ELSE BEGIN
            W[L]:=K;  S:=1.0/Y[L];
            FOR J:=1 TO M DO U[L,J]:=U[L,J]*S;
            IF L = 1 THEN I:=2 ELSE I:=1;
            REPEAT
               S:=Y[I];  X[I]:=X[I]-D*S;
               FOR J:=1 TO M DO U[I,J]:=U[I,J]-U[L,J]*S;
               IF I = L-1 THEN I:=I+2 ELSE I:=I+1
            UNTIL I > Q;
            X[L]:=D
         END  { ELSE: NOT EX }
      END  { ELSE: D <= -EPS }
   UNTIL STOP
END;  { PSIMPLEX }


